 ; Ŀ
 ;   Dent - search and replace for attribute prompts in the block tables.  
 ;   Copyright 1996, 2006 by Rocket Software Ltd.                          
 ;   Special cases: 1. If %% is input for the existing string then Dent    
 ;                     doesn't ask for a replacement string and the first  
 ;                     letter in all prompts in the selected block         
 ;                     definitions is converted to upper case.             
 ;                  2. If %%% is input for the existing string then Dent   
 ;                     doesn't ask for a replacement string and the        
 ;                     prompt is converted by word to leading caps and     
 ;                     the rest lower case.                                
 ;                  3. If %% is input for the replacement string then      
 ;                     it is assumed to be empty.                          
 ;                                                                         
 ;   Like a .44 magnum that can only be fired at poodles, this routine     
 ;   is powerful, dangerous in the wrong hands, and difficult to see any   
 ;   legitimate use for.  Then again, some things are irritating enough    
 ;   to make the risk acceptable.                                          
 ;                                                                         
 ; 

 ; Ŀ
 ;   Chug - string substitution engine.  Takes the search string, the      
 ;   replacement string, and the target string as arguments, and returns   
 ;   the (possibly modified) target string and the number of changes made. 
 ; 
 (DEFUN CHUG (oldstr newstr exstr / pos chnum changd newlen chunk)
  (setq pos 1)
  (setq chnum 0)
  (setq changd ())
  (setq newlen (strlen newstr))
  (setq oldlen (strlen oldstr))
  (while (= oldlen (strlen (setq chunk (substr exstr pos oldlen))))
         (if (= chunk oldstr)
             (progn
                  (setq exstr (strcat (substr exstr 1 (1- pos))
                                       newstr
                                      (substr exstr (+ pos oldlen))))
                  (setq changd t)
                  (setq chnum (1+ chnum))
                  (setq pos (+ pos newlen)))
             (setq pos (1+ pos))))
 (list exstr chnum))
 ; Ŀ
 ;   Chug - end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Fdash - split a string at any character in a list,         
 ;   capitalise each resulting substring, reassemble the string.           
 ;   Also watches for certain special cases.                               
 ;   Arguments: Astr: the string to process.                               
 ;              Chra: the list of separator characters.                    
 ;   Recursive.                                                            
 ; 
 (DEFUN FDASH (chra astr / sub prlist nustra nump)
  (if (and astr 
           (car chra)
           (> (length (setq prlist (splat (car chra) astr))) 0))
      (progn
           (setq nustra "")
           (while (setq sub (car prlist))
                  (setq prlist (cdr prlist))
                  (setq sub (strcase sub t))
                  (cond ((= (substr sub 1 1) "(")               ; balance: )
                         (setq sub (strcat "(" (car (hug (substr sub 2)))))) ;)
                        ((or (and (> (setq nump (sonar "." sub t)) 0)
                                  (/= (substr sub (strlen sub)) "."))
                             (> nump 1))
                         (setq sub (strcase sub)))
                        ((member sub '("vsat" "mds" "vavcu"))
                         (setq sub (strcase sub)))
                        (T (setq sub (car (hug sub)))))
                  (setq sub (fdash (cdr chra) sub))             ; recurse
                  (setq nustra (strcat nustra (car chra) sub)))
           (if (= (substr nustra 1 1) (car chra))
               (setq nustra (substr nustra 2))))
      (setq nustra astr))
 nustra)
 ; Ŀ
 ;   Fdash.                                                                
 ; 

 ; Ŀ
 ;   Hug - string capitaliser.  Takes one argument, a string, and returns  
 ;   a list: the string with the first letter changed to upper case and    
 ;   T if this changed the string, () if not.                              
 ; 
 (DEFUN HUG (exstr / chunk1 chunka)
  (setq chunk1 (substr exstr 1 1))
  (if (= chunk1 (setq chunka (strcase chunk1)))
      (list exstr ())
      (list (strcat chunka (substr exstr 2)) T)))
 ; Ŀ
 ;   Hug - end.                                                            
 ; 

 ; Ŀ
 ;   Rust - change a prompt string in the block tables.                    
 ;   Notes: 1. Entnext returns nil after the last entity in a block        
 ;             definition.                                                 
 ;          2. An empty block has one subentity of type Endblk.            
 ;   Takes 3 arguments - the first subentity ename, the search string      
 ;   and the replacement string.                                           
 ;   Returns a list of the number of prompt strings changed and the        
 ;   total number of changes.                                              
 ; 
 (DEFUN RUST (namm oldstr newstr / attchg chgnum entt prom1 prom2 altr mods
                                                                        nup)
  (setq attchg 0)
  (setq chgnum 0)
  (while (and namm (setq entt (entget namm)))            ; the whole thing
         (if (setq prom1 (assoc 3 entt))
             (progn
                  (setq prom2 (cdr prom1))
                  (setq altr (chug oldstr newstr prom2))
                  (if (> (setq mods (cadr altr)) 0)      ; if any changes made
                      (progn
                           (setq nup (car altr))
                           (entmod (subst (cons 3 nup) prom1 entt))
                           (setq attchg (1+ attchg))
                           (setq chgnum (+ chgnum mods))))))
         (setq namm (entnext namm)))                     ; next subentity ename
 (list attchg chgnum))
 ; Ŀ
 ;   Rust end.                                                             
 ; 

 ; Ŀ
 ;   Sonar - see if a string contains a substring.                         
 ;   Arguments:  Loc, the substring.                                       
 ;               Txt, the string.                                          
 ;               Cas, if this is non-nil then the search                   
 ;                                is non-case-sensitive.                   
 ;   Returns the number of occurrences of the substring.                   
 ; 
 (DEFUN SONAR (loc txt cas / chflg ln sta st)
  (setq chflg 0)
  (if cas 
      (progn
           (setq loc (strcase loc t))
           (setq txt (strcase txt t))))
  (setq ln (strlen loc))
  (setq sta 1)
  (while (= ln (strlen (setq st (substr txt sta ln))))
         (if (= st loc) (setq chflg (1+ chflg)))
         (setq sta (1+ sta)))
 chflg)
 ; Ŀ
 ;   Sonar end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Splat - divide a text string into a list of substrings.    
 ;   Arguments: Sepchr, the field separator character.                     
 ;              Linn, the text string.                                     
 ;   Returns a list of field values, removes leading and trailing spaces.  
 ; 
 (DEFUN SPLAT (sepchr linn / len pos name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) sepchr)
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (while (= (substr name1 (setq len (strlen linn))) " ")
                (setq name1 (substr name1 1 (1- len))))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Splat end.                                                            
 ; 

 ; Ŀ
 ;   Strum - capitalise a prompt string in the block tables.               
 ;   Arguments: Namm, the first subentity ename.                           
 ;              Proc, 1 = initial uppercase.                               
 ;                    2 = initial uppercase, rest lowercase.               
 ;   Returns a list of the number of prompt strings changed and the        
 ;   total number of changes (which will be the same).                     
 ; 
 (DEFUN STRUM (namm proc / attchg entt prom1 nup)
  (setq attchg 0)
  (while (and namm (setq entt (entget namm)))            ; the whole thing
         (if (setq prom1 (assoc 3 entt))
             (progn
                  (cond ((= proc 1)
                         (setq nup (hug (cdr prom1))))
                        ((= proc 2)      ; assume there will be a change
                         (setq nup (list (fdash (list " " "-" "/") (cdr prom1))
                                          1))))
                  (if (cadr nup)
                      (progn
                           (entmod (subst (cons 3 (car nup)) prom1 entt))
                           (setq attchg (1+ attchg))))))
         (setq namm (entnext namm)))                     ; next subentity ename
 (list attchg attchg))
 ; Ŀ
 ;   Strum end.                                                            
 ; 

 ; Ŀ
 ;   Dent.                                                                 
 ; 
 (DEFUN C:DENT (/ ach bch tchs ss num enam namm namlst oldp newp blokdat
                                                        first blnam chgs reww)
  (setq ach 0)         ; number of attdefs changed
  (setq bch 0)         ; number of block definitions changed
  (setq tchs 0)        ; total number of changes
 ; Ŀ
 ;   Get blocks to change.                                                 
 ; 
  (prompt "Select examples of blocks to change or <Enter> for all blocks: ")
  (setq ss (ssget (list (cons 0 "insert") (cons 66 1))))
  (if (null ss) (prompt "\nAll blocks will be modified."))
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (setq namm (cdr (assoc 2 (entget enam))))
         (if (not (member namm namlst))
             (setq namlst (append namlst (list namm)))))
 ; Ŀ
 ;   Get old and new prompt strings.                                       
 ; 
  (if (/= (type oldstr) 'STR)
      (setq oldstr "Enter "))
  (if (/= (type newstr) 'STR)
      (setq newstr ""))
  (setq oldp (getstring t (strcat "\nString to replace <" oldstr ">: ")))
  (if (/= oldp "") (setq oldstr oldp))
  (if (not (member oldstr '("%%" "%%%")))
      (progn
           (setq newp (getstring t (strcat "\nNew string <" newstr ">: ")))
           (if (/= newp "") (setq newstr newp))
           (if (= newstr "%%") (setq newstr ""))))
 ; Ŀ
 ;   Change the selected blocks, or all blocks if none were selected.      
 ; 
  (if namlst
     (progn
          (while (setq namm (car namlst))
                 (setq namlst (cdr namlst))
                 (setq blokdat (tblsearch "block" namm))
                 (setq first (substr (setq blnam (cdr (assoc 2 blokdat))) 1 1))
                 (grtext -2 blnam)
                 (if (/= first "*")
                     (progn
                          (setq namm (cdr (assoc -2 blokdat)))
                          (cond ((= oldstr "%%")
                                 (setq chgs (strum namm 1)))
                                ((= oldstr "%%%")
                                 (setq chgs (strum namm 2)))
                                (t
                                 (setq chgs (rust namm oldstr newstr))))
                          (if (> (car chgs) 0) (setq bch (1+ bch)))
                          (setq ach (+ ach (car chgs)))
                          (setq tchs (+ tchs (cadr chgs)))))))
     (progn
          (setq reww T)
          (while (setq blokdat (tblnext "block" reww))
                 (setq reww ())
                 (setq first (substr (setq blnam (cdr (assoc 2 blokdat))) 1 1))
                 (grtext -2 blnam)
                 (if (/= first "*")
                     (progn
                          (setq namm (cdr (assoc -2 blokdat)))
                          (cond ((= oldstr "%%")
                                 (setq chgs (strum namm 1)))
                                ((= oldstr "%%%")
                                 (setq chgs (strum namm 2)))
                                (t
                                 (setq chgs (rust namm oldstr newstr))))
                          (if (> (car chgs) 0) (setq bch (1+ bch)))
                          (setq ach (+ ach (car chgs)))
                          (setq tchs (+ tchs (cadr chgs))))))))
 ; Ŀ
 ;   Sum up and end.                                                       
 ; 
  (write-line (strcat (itoa tchs) " change" (if (/= tchs 1) "s" "") " in "
                      (itoa ach) " prompt"  (if (/= ach 1) "s" "") " in "
                      (itoa bch) " block definition" (if (/= bch 1) "s." ".")))
 (princ))